<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<title>IBSheet7-Product</title>

	<script type="text/javascript" src="../js/common.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts-more.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/funnel.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/heatmap.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/drilldown.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/gantt.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/boost.js"></script>
	<script type="text/javascript" src="../Chart/ibchart.js"></script>
	<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
	<script type="text/javascript" src="./chartTypeOptions.js"></script>
	<script type="text/javascript" src="https://unpkg.com/canvg@3.0.4/lib/umd.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			createIBChart("etcChart", "etcChart", {
				width: "100%",
				height: "85%"
			});

			etcChartDraw();
		});

		function etcChartDraw(){
			var Type = $("#etcCombo").val();
			etcChart.removeAll();
			etcChart.setOptions(etcChartOption);
			switch(Type){
				case "SCATTER": //산점 차트
				etcChart.setOptions({
					chart: {
						type:"scatter"
						,zoomType: "xy"
					}
				},{
					append : true
				});

				doSearch(etcChart,"chartdata_scatter.json");
				break;

				case "BUBBLE": //버블(거품) 차트
				etcChart.setOptions({
					chart: {
						type:"bubble"
						,zoomType: "xy"
					}
				},{
					append : true
				});

				doSearch(etcChart,"chartdata_bubble.json");
				break;
				case "WaterFall":
				etcChart.setOptions({
					chart: {
						type:"waterfall"
					},
					xAxis:{
						categories: ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월']
					},
					plotOptions: {
						column: {
							borderColor: "#999999"
						},
						series: {
							stacking: "",
							dataLabels: {
								enabled: true,
								align:"center",
								color : "#333333"
							}
						},
						waterfall: {
							color : "#ff0000",
							lineColor : "#00ff00",
							lineWidth : 1
						}
					}
				},{
					append : true
				});

				doSearch(etcChart, "waterfallchartdata.xml");
				break;
				case "POLAR":
				etcChart.setOptions({
					chart: {
						type:"line",
						polar:true
					},
					xAxis: {
						tickmarkPlacement : "on",
						lineWidth: 0
					},
					yAxis: {
						title: {
							text:""
						},
						tickInterval : 200,
						gridLineInterpolation : "polygon",
						lineWidth: 0
					},
					plotOptions: {
						series: {
							marker: {
								enabled: true
							}
						}
					}
				},{
					append : true
				});

				doSearch(etcChart, "chartdata_polar.xml");
				break;
				case "BOXPLOT":
				etcChart.setOptions({
					chart: {
						type:"boxplot"
					},
					tooltip: {
						enabled:true,
						background:"#EDEDED",
						formatter:function(){
							return this.point.name + ' <br>최대값 : ' + this.point.high +"<br>최소값 : "+this.point.low;
						}
					}
				},{
					append : true
				});

				doSearch(etcChart, "chartdata_boxplot.xml");
				break;
				case "GAUGE":
				etcChart.setOptions({
					chart: {
						type: 'gauge',
						plotBackgroundColor:{
							linearGradient: [250,0, 250, 500],
							stops: [
							[0, 'rgb(255, 255, 255)'],
							[1, 'rgb(235, 235, 235)']
							]
						},
						zoomType:'x',

						plotBorderColor:"#A9AEB1",
						plotBorderWidth:1,
						backgroundColor:{
							linearGradient : [0,0,100,500],
							stops : [
							[0, "#D7E1F3"],
							[1, "#FFFFFF"]
							]
						},

						borderColor : "#84888B"
					},
					title:{
						style:{
							Color:"#15498B",
							fontFamily:"Dotum",
							fontWeight:"bold",
							fontSize:"13px"
						},
						text:"그 외  차트 유형"
					},

					pane: {
						startAngle: -120,
						endAngle: 120,
						background: [{
							// backgroundColor: {
							// 	linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
							// 	stops: [
							// 	[0, '#FFF'],
							// 	[1, '#333']
							// 	]
							// },
							borderWidth: 0,
							outerRadius: '109%'
						}, {
							// backgroundColor: {
							// 	linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
							// 	stops: [
							// 	[0, '#333'],
							// 	[1, '#FFF']
							// 	]
							// },
							borderWidth: 1,
							outerRadius: '107%'
						}, {
						// default background
						backgroundColor: '#DDD',
						borderWidth: 0,
						outerRadius: '105%',
						innerRadius: '103%'
					}]
				},

					// the value axis
					yAxis: {
						min: 0,
						max: 100,

						minorTickInterval: 'auto',
						minorTickWidth: 1,
						minorTickLength: 10,
						minorTickPosition: 'inside',
						minorTickColor: '#666',

						tickPixelInterval: 30,
						tickWidth: 2,
						tickPosition: 'inside',
						tickLength: 10,
						tickColor: '#666',
						labels: {
							step: 2,
							rotation: 'auto'
						},
						gridLineWidth: 0,
						title: {
							text: '이행율(%)'
						},
						plotBands: [{
							from: 0,
							to: 40,
							color: '#DF5353'
						}, {
							from: 40,
							to: 70,
							color: '#DDDF0D'
						}, {
							from: 70,
							to: 100,
							color: '#55BF3B'
						}]
					},

					series: [{
						name: '이행율',
						data: [75],
						tooltip: {
							valueSuffix: '%'
						}
					}]
				},{
					append: true,
					redraw: true
				});
				break;
				case "HeatMap":
				var option = {

					chart: {
						type: 'heatmap',
						marginTop: 40,
						marginBottom: 40,
						plotBackgroundColor:{
							linearGradient: [250,0, 250, 500],
							stops: [
							[0, 'rgb(255, 255, 255)'],
							[1, 'rgb(235, 235, 235)']
							]
						},
						zoomType:'x',

						plotBorderColor:"#A9AEB1",
						plotBorderWidth:1,
						backgroundColor:{
							linearGradient : [0,0,100,500],
							stops : [
							[0, "#D7E1F3"],
							[1, "#FFFFFF"]
							]
						},

						borderColor : "#84888B"
					},
					Title:{
						style:{
							Color:"#15498B",
							fontFamily:"Dotum",
							fontWeight:"bold",
							fontSize:"13px"
						},
						text:"그 외  차트 유형"
					},


					xAxis: {
						labels:{
							enabled:false
						}
						// categories: ['Alexander', 'Marie', 'Maximilian', 'Sophia', 'Lukas', 'Maria', 'Leon', 'Anna', 'Tim', 'Laura']
					},

					yAxis: {
						labels:{
							enabled:false
						},
						// categories: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'],
						title: null
					},

					colorAxis: {
						min: 0,
						minColor: '#FFFFFF',
						maxColor: "#FF0000"

					},

					legend: {
						align: 'right',
						layout: 'vertical',
						margin: 0,
						verticalAlign: 'middle'
						// y: 25,
						// symbolHeight: 320
					},

					tooltip: {
						enabled:true,
						formatter: function () {
							return this.point.name+":<b>"+  (this.point.value).toLocaleString()+"</b>명";
						}
					},

					series: [{
						name: '각 구별 인구',
						borderWidth: 1,
						data: [
						{x:0,y:0,value:166200, name:"종로구" },
						{x:0,y:1,value:136773, name:"중구"  },
						{x:0,y:2,value:249930, name:"용산구" },
						{x:0,y:3,value:305752, name:"성동구" },
						{x:0,y:4,value:379408, name:"광진구" },
						{x:1,y:0,value:375232, name:"동대문구"},
						{x:1,y:1,value:424054, name:"중랑구" },
						{x:1,y:2,value:479810, name:"성북구" },
						{x:1,y:3,value:339692, name:"강북구" },
						{x:1,y:4,value:357298, name:"도봉구" },
						{x:2,y:0,value:588767, name:"노원구" },
						{x:2,y:1,value:504603, name:"은평구" },
						{x:2,y:2,value:323560, name:"서대문구"},
						{x:2,y:3,value:390092, name:"마포구" },
						{x:2,y:4,value:491860, name:"양천구" },
						{x:3,y:0,value:588123, name:"강서구" },
						{x:3,y:1,value:458226, name:"구로구" },
						{x:3,y:2,value:258496, name:"금천구" },
						{x:3,y:3,value:422925, name:"영등포구"},
						{x:3,y:4,value:421304, name:"동작구" },
						{x:4,y:4,value:533792, name:"관악구" },
						{x:4,y:0,value:452922, name:"서초구" },
						{x:4,y:1,value:579102, name:"강남구" },
						{x:4,y:2,value:675021, name:"송파구" },
						{x:4,y:3,value:483397, name:"강동구"	}
						],
						dataLabels: {
							enabled: true,
							color: 'white',
							format: '{point.name}',
							style: {
								textTransform: 'uppercase'
							}
						}
					}]
				};
				etcChart.setOptions(option,{
					append: true,
					redraw: true
				});

				break;
				case "Pyramid":
				var opt = {
					chart: {
						type: 'pyramid',
						marginTop: 40,
						marginBottom: 40,
						plotBackgroundColor:{
							linearGradient: [250,0, 250, 500],
							stops: [
							[0, 'rgb(255, 255, 255)'],
							[1, 'rgb(235, 235, 235)']
							]
						},
						plotBorderColor:"#A9AEB1",
						plotBorderWidth:1,
						backgroundColor:{
							linearGradient : [0,0,100,500],
							stops : [
							[0, "#D7E1F3"],
							[1, "#FFFFFF"]
							]
						},

						borderColor : "#84888B"
					},
					title:{
						style:{
							Color:"#15498B",
							fontFamily:"Dotum",
							fontWeight:"bold",
							fontSize:"13px"
						},
						text:"그 외  차트 유형"
					},
					plotOptions: {
						series: {
							dataLabels: {
								enabled: true,
								format: '<b>{point.name}</b> ({point.y:,.0f}명)',
								color: 'black',
								softConnector: true
							},
							showInLegend: true
						},
						pyramid:{
							width:"50%"
						}
					},
					legend: {
						title:{
							text:"연령별 인터넷 사용자 수"
						},
						enabled:true,
						align: 'right',
						layout: 'vertical',
						verticalAlign: 'middle'
					},
					colors: ["#0072ff", "#f83600", "#71B280", "#e9d362", "#6E48AA"],
					series: [{
						name: '인터넷 이용자 수',
						data: [
						['10대', 6620],
						['20대', 7280],
						['30대', 8090],
						['40대', 6600],
						['50대', 2660],
						['60대 이상', 1190]
						]
					}]
				};
				etcChart.setOptions(opt,{
					append: true,
					redraw: true
				});
				break;
			}
		}

		function Down2Image(Type){
			switch (Type)
			{
				case "PNG":
					//chart객체, 파일명
					downChart2Image(etcChart,"특수차트.png");
				break;

				

			}
		}

		function doSearch(chart,url,subparam){
			$.ajax({
				type: 'post'
				, async: true
				, dataType:"text"
				, url: url
				, data:  subparam
				, beforeSend: function() {

				}
				, success: function(JSON) {
					chart.loadSearchData(JSON, {
						append: true
					});
				}
				, error: function(data, status, err) {
					alert('서버와의 통신이 실패했습니다.');
				}
				,complete:function(jqXHR,textStatus){

				}
			});
		}

		function DoPrint(){
			etcChart.doPrint();
		}
	</script>
</head>
<body>
	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트 유형 > <b>특수형 타입</b></span>
	</div>
	<div class="main_content">
		<div style="float:left;width:100%">
			<div class="exp_product" style="float:left;width:30%">
				특수형 차트를 확인합니다.
			</div>
			<div class="ib_function" style="float:left;width:70%;text-align:right">
				<a href="javascript:Down2Image('PNG')" class="f1_btn_white gray">이미지 다운로드</a>
				<a href="javascript:DoPrint()" class="f1_btn_white gray">이미지 프린트</a>
			</div>
		</div>
		<div class="clear hidden"></div>
		<p class="subtit_chart">차트 유형</p>
		<div class="ib_chart_product">
			<select class="chartCombo" id="etcCombo" onchange="etcChartDraw()">
				<option value="POLAR">방사형</option>
				<option value="SCATTER" >산점</option>
				<option value="BUBBLE" >버블</option>
				<option value="BOXPLOT">고저시종</option>
				<option value="GAUGE">게이지</option>
				<option value="HeatMap">히트맵</option>
				<option value="Pyramid">피라미드</option>
				<option value="WaterFall" >폭포형</option>
				<!--
				<option value="폭포형"></option>
				<option value="깔데기"></option>
				<option value="피라미드"></option>
				<option value="GAUGE2">게이지2</option>
			-->
		</select>
		<div style="height:10px"></div>
		<div id="etcChart"></div>
	</div>
</div>
<!--main_content-->
</body>
</html>